﻿using System;
using System.Collections.Generic;

public class InterfaceTester
{
    public static int Main()
    {
        string recommendation;
        FinancialAdvisor finad = new FinancialAdvisor();
        InterfaceTester iftst = new InterfaceTester();

        finad.PriceChange += new ChangeRegistrar(
                                iftst.PricePerTradeChange);

        finad["ABC"] = 15.39m;
        finad["DEF"] = 37.51m;

        Console.WriteLine("Cena ABC wynosi {0}", finad["ABC"]);
        Console.WriteLine("Cena DEF wynosi {0}", finad["DEF"]);

        Console.WriteLine("");

        finad.PricePerTrade = 10.55m;

        // Właściwość HourlyFees jest ukryta i nie może zostać skompilowana
        //finad.HourlyFees    = 9.00m;

        Console.WriteLine("");

        recommendation = ((IBroker)finad).GetRating("ABC");

        Console.WriteLine(
            "Zalecenie (IBroker)finad dla akcji ABC {0}",
            recommendation);

        recommendation = ((IAdvisor)finad).GetRating("ABC");

        Console.WriteLine(
            "Zalecenie (IAdvisor)finad dla akcji ABC {0}",
            recommendation);

        return 0;

        //string recommendation;
        //List<IBroker> brokers = new List<IBroker>();

        //brokers.Add(new FinanceCompany(7.32m));
        //brokers.Add(new StockBroker(11.51m, "Dom maklerski"));

        //InterfaceTester iftst = new InterfaceTester();

        //foreach (IBroker broker in brokers)
        //{
        //    broker.PriceChange += new ChangeRegistrar(
        //                        iftst.PricePerTradeChange);

        //    broker["ABC"] = 15.39m;
        //    broker["DEF"] = 37.51m;

        //    Console.WriteLine("");
        //    Console.WriteLine("Cena ABC wynosi {0}", broker["ABC"]);
        //    Console.WriteLine("Cena ABC wynosi {0}", broker["DEF"]);

        //    Console.WriteLine("");

        //    broker.PricePerTrade = 10.55m;

        //    Console.WriteLine("");

        //    recommendation = broker.GetRating("ABC");

        //    Console.WriteLine(
        //    "Zalecane działanie dla ABC {0}",
        //    recommendation);
        //}

        //return 0;
    }

    public void PricePerTradeChange(object sender,
                                    object evnt)
    {
        Console.WriteLine(
            "{0}: Cena transakcji została zmieniona na {1}",
             (string)sender, (decimal)evnt);
    }
}
